function [ F Fmu Fsigma ] = fct_CDF_F_capped_prime(t,mu,sigma)
% CDF of the times tau a Brownian motion {X(t)} with (mu,sigma)  hits
%X(tau)=1 starting at X(0)=0
%

if t < 1e-5
    F=0;
    Fmu=0;
    Fsigma=0;
else
    
    modet  = 1/mu*((1+9/(4*mu^2/sigma^4))^0.5-3/(2*mu/sigma^2));
    stdev = sqrt(sigma^2/mu^3);
    
    %
    %
    F = normcdf( -(1-mu.*t)./(sigma.*sqrt(t)) ) + exp(2*mu./sigma.^2).*normcdf( -(1+mu.*t)./(sigma.*sqrt(t)) ) ;
    Fmu =                      normpdf( -(1-mu.*t)./(sigma.*sqrt(t)) ) .* sqrt(t)./sigma ...
        - exp(2*mu./sigma.^2).*normpdf( -(1+mu.*t)./(sigma.*sqrt(t)) ) .* sqrt(t)./sigma ...
        +  2./(sigma.^2) .* exp(2*mu./sigma^2) .* normcdf( -(1+mu.*t)./(sigma.*sqrt(t)) );
    Fsigma =                    normpdf( -(1-mu.*t)./(sigma.*sqrt(t)) ) .*(1-mu.*t) ./ (sqrt(t).*sigma.^2) ...
        + exp(2*mu./sigma.^2).*normpdf( -(1+mu.*t)./(sigma.*sqrt(t)) ) .*(1+mu.*t) ./ (sqrt(t).*sigma.^2) ...
        -  4 .* mu ./(sigma.^3) .* exp(2*mu./sigma^2) .* normcdf( -(1+mu.*t)./(sigma.*sqrt(t)) );
    %else
    
    if sum(isnan(F))>0
        % F = 0 for t < mode-stdev
        select = t <=(modet - stdev);
        F(select) = 0;
        % F = 1 for t > mode+stdev
        select = t >(modet + stdev);
        F(select) = 1;
        % in between, just linear approximation
        select = (t>(modet - stdev))& (t <=(modet + stdev));
        Ns = sum(select);
        F(select) = [1:1:Ns]/Ns;
        %end
    end
    
    if 2*mu/sigma^2 > 700;
        Fmu=0;
        Fsigma=0;
    end
    
end

end

